"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOsName = exports.debug = void 0;
var fs_1 = __importDefault(require("fs"));
var os_1 = __importDefault(require("os"));
var debug = function (message) {
    // TODO: Some propper logging would be nice!
    try {
        // Attempting to write directly to stdout so whoever may intercept my console.log does not get this.
        fs_1.default.writeSync(1, message);
    }
    catch (_a) {
        // Can't write to sysout, let node handle it.
        console.log(message);
    }
};
exports.debug = debug;
var getOsName = function () {
    var osType = os_1.default.type();
    return osType === "Darwin"
        ? "macos"
        : osType === "Windows_NT"
            ? "windows"
            : "linux";
};
exports.getOsName = getOsName;
